<?php
require_once('header.php');

// Preventing the direct access of this page.
if(!isset($_REQUEST['slug']))
{
	header('location: index.php');
	exit;
}
else
{
	// Check the page slug is valid or not.
	$statement = $pdo->prepare("SELECT * FROM tbl_page WHERE page_slug=? AND status=?");
	$statement->execute(array($_REQUEST['slug'],'Active'));
	$total = $statement->rowCount();
	if( $total == 0 )
	{
		header('location: index.php');
		exit;
	}
}

// Getting the detailed data of a page from page slug
$statement = $pdo->prepare("SELECT * FROM tbl_page WHERE page_slug=?");
$statement->execute(array($_REQUEST['slug']));
$result = $statement->fetchAll(PDO::FETCH_ASSOC);							
foreach ($result as $row) 
{
	$page_name    = $row['page_name'];
	$page_slug    = $row['page_slug'];
	$page_content = $row['page_content'];
	$page_layout  = $row['page_layout'];
	$banner       = $row['banner'];
	$status       = $row['status'];
}

// If a page is not active, redirect the user while direct URL press
if($status == 'Inactive')
{
	header('location: index.php');
	exit;
}
?>
		
 <div class="page-content about-page">
<!-- HEADING PAGE-->
        <section class="heading-page heading-agent-list-1 heading-services-detail-5" style="background: url(<?php echo BASE_URL; ?>assets/uploads/<?php echo $banner; ?>) center center no-repeat;">
            <div class="container">
                <ul class="au-breadcrumb">
                    <li class="au-breadcrumb-item">
                        <a href="<?php echo BASE_URL; ?>">Home</a>
                    </li>
                    
                </ul>
                <div class="heading-title">
                    <h1>
					<?php echo $page_name; ?>
					</h1>
                </div>
            </div>
        </section>
        <!-- END HEADING PAGE-->


<?php if($page_layout == 'Full Width Page Layout'): ?>




	<!-- SECTION ABOUT, STYLE 2-->
        <section class="about about-layout-1">
            <div class="container">
                <div class="row">
                    <div class="col-md-6 col-sm-12 col-md-push-6">
                        <div class="image">
                            <img src="img/about/company.jpg" alt="Our Team" />
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12 col-md-pull-6">
                        <div class="main-post">
                            <p class="content">
                                <?php echo $page_content; ?></p>

                                
                        </div>

                        
                    </div>


                </div>
            </div>
        </section>
        <!-- END SECTION ABOUT, STYLE 2-->
<?php endif; ?>


<?php if($page_layout == 'Contact Us Page Layout'): ?>
<?php
	$statement = $pdo->prepare("SELECT * FROM tbl_settings WHERE id=1");
	$statement->execute();
	$result = $statement->fetchAll(PDO::FETCH_ASSOC);							
	foreach ($result as $row) 
	{
		$contact_map_iframe = $row['contact_map_iframe'];
	}
?>
<section class="contact contact-layout style-3">
            <div class="main-contact">
                <div class="container">
                    <div class="row">
                        <div class="col-md-8">

<?php
// After form submit checking everything for email sending
if(isset($_POST['form_contact']))
{
	$error_message = '';
	$success_message = '';
	$statement = $pdo->prepare("SELECT * FROM tbl_settings WHERE id=1");
	$statement->execute();
	$result = $statement->fetchAll(PDO::FETCH_ASSOC);							
	foreach ($result as $row) 
	{
		$receive_email = $row['receive_email'];
		$receive_email_subject = $row['receive_email_subject'];
		$receive_email_thank_you_message = $row['receive_email_thank_you_message'];
	}

    $valid = 1;

    if(empty($_POST['visitor_name']))
    {
        $valid = 0;
        $error_message .= 'Please enter your name.\n';
    }

    if(empty($_POST['visitor_phone']))
    {
        $valid = 0;
        $error_message .= 'Please enter your phone number.\n';
    }


    if(empty($_POST['visitor_email']))
    {
        $valid = 0;
        $error_message .= 'Please enter your email address.\n';
    }
    else
    {
    	// Email validation check
        if(!filter_var($_POST['visitor_email'], FILTER_VALIDATE_EMAIL))
        {
            $valid = 0;
            $error_message .= 'Please enter a valid email address.\n';
        }
    }

    if(empty($_POST['visitor_comment']))
    {
        $valid = 0;
        $error_message .= 'Please enter your comment.\n';
    }

    if($valid == 1)
    {
		
		$visitor_name = strip_tags($_POST['visitor_name']);
		$visitor_email = strip_tags($_POST['visitor_email']);
		$visitor_phone = strip_tags($_POST['visitor_phone']);
		$visitor_comment = strip_tags($_POST['visitor_comment']);

        // sending email
        $to_admin = $receive_email;
        $subject = $receive_email_subject;
		$message = '
<html><body>
<table>
<tr>
<td>Name</td>
<td>'.$visitor_name.'</td>
</tr>
<tr>
<td>Email</td>
<td>'.$visitor_email.'</td>
</tr>
<tr>
<td>Phone</td>
<td>'.$visitor_phone.'</td>
</tr>
<tr>
<td>Comment</td>
<td>'.nl2br($visitor_comment).'</td>
</tr>
</table>
</body></html>
';
		$headers = 'From: ' . $visitor_email . "\r\n" .
				   'Reply-To: ' . $visitor_email . "\r\n" .
				   'X-Mailer: PHP/' . phpversion() . "\r\n" . 
				   "MIME-Version: 1.0\r\n" . 
				   "Content-Type: text/html; charset=ISO-8859-1\r\n";

		// Sending email to admin				   
        mail($to_admin, $subject, $message, $headers); 
		
        $success_message = $receive_email_thank_you_message;

    }
}
?>
				
				<?php
				if($error_message != '') {
					echo "<script>alert('".$error_message."')</script>";
				}
				if($success_message != '') {
					echo "<script>alert('".$success_message."')</script>";
				}
				?>




                            <form class="contact-form" name="contactform" method="post">
                                <div class="heading">
                                    <h3>Send Us a Message</h3>
                                </div>
                                <div class="input-group">
                                    <div class="input">
                                        <input type="text" name="visitor_name" placeholder="Your Name" />
                                    </div>
                                    <div class="input">
                                        <input type="text" name="visitor_email" placeholder="Your Email" />
                                    </div>
                                    <div class="input">
                                        <input type="text" name="visitor_phone" placeholder="Phone Number" />
                                    </div>
                                </div>
                                <div class="text-area">
                                    <textarea placeholder="Your Messages" name="visitor_comment"></textarea>
                                </div>
                                <div class="action-group">
                                    <button class="au-btn au-btn-orange au-btn-lg" name="form_contact" type="submit">Send</button>
                                </div>
                            </form>
                        </div>
                        <div class="col-md-4">
                            <div class="google-map">
							<?php echo $contact_map_iframe; ?>
							</div>	
                        </div>
                    </div>
                </div>
            </div>
           
        </section>
        <!-- END CONTACT, STYLE 3-->







<?php endif; ?>



<?php if($page_layout == 'FAQ Page Layout'): ?>
 <section class="about about-layout-1">
            <div class="container">
                <div class="row">
                    <div class="col-md-6 col-sm-12 col-md-push-6">
                        <div class="image">
                            <img src="img/about/strategy_img.jpg" alt="Our Team" />
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12 col-md-pull-6">
                        <div class="main-post">
                            <h3 class="heading">
                           
Our Investment Strategy

                            </h3>
                            <p class="content">
                                We believe long-term investment success stems from spotting underlying value, not market timing or gimmicks. We strive to avoid being distracted by the latest investment fad or apocalypse du jour. Instead of reacting to every short-term movement of the market, we focus on implementing our process. It isn’t hard to decide to invest according to the fundamentals. What's hard is sticking with it. After all, markets rise and fall. Events happen in the world and in our lives. Hot tips get traded at the club. And even the most experienced investor can be swayed from the course. At Worldbase Loan Services, we have spent years developing processes that help keep us focused on long-term strategy. Because there's no magic that creates a successful investor - it's about experience, diligence, and attention to detail.
                                <br><br>

                                Whether it was timing, your work and due diligence or structuring, your successes were born from an idea. Worldbase Loan Services, we are also driven by ideas. Through technical knowledge and understanding to execution, we turn investment ideas into reality. But we not only work to understand market trends, but you as well. We believe in a relationship that actively engages you. Managing market conditions, portfolio expectations & risks - we at Worldbase Loan Services strive to prosper with you. This is possible by nurturing a team of astute and technically sound account managers & financial personels. A team grounded with a high sense of responsibility dedicated on earning your trust. Our approach is simple.

                                <br><br>

                                Since we're not chasing the next big thing, we disregard short-term market noise and speculation. Instead, we focus on stamina and expertise. Disciplined analysis. Back-testing our assumptions. Selecting money managers with sector strength and the proven ability to deliver long-term results. Of course we closely monitor market movements and stay abreast of changing conditions. But we count on the checks and balances built into our processes to help detach human emotion - especially fear and greed - from our investment decisions and yours. It's another example of Behavioral Wealth Management in action. Your requirements and objectives are unique to you, and a "one size fits all" service is probably not what you seek. At Worldbase Loan Services, we tailor our services to your needs and help you develop a comprehensive wealth management solution.
                            </p>
                            


                                
                        </div>

                    </div>


                </div>
            </div>
        </section>
        <!-- END SECTION ABOUT, STYLE 2-->
<?php endif; ?>



<?php if($page_layout == 'Photo Gallery Page Layout'): ?>
<!-- PROJECT LIST-->
        <section class="projects-layout">
            <div class="container">
                <div class="project-subjects">
                    <ul class="filter-button-group">
                        <!-- <li class="is-checked button" data-filter=".Financial, .Investments, .Taxes, .Insurance, .Retirement">
                            <h4>Completed and Ongoing Projects</h4>
                        </li> -->
                        
                    </ul>
                </div>
                <div class="row isotope-grid">
                    <div class="col-md-4 col-sm-6 col-xs-12 isotope-item Retirement">
                        <div class="project-item match-item">
                            <div class="project-item-img">
                                <img class="img-responsive" src="img/projects/p1.jpg" alt="project-1.jpg" />
                            </div>
                            <div class="project-item-title">
                                <a href="#">Clean Energy: Ongoing Clean Energy project at Madrid, Spain $89 million USD</a>
                            </div>
                            
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6 col-xs-12 isotope-item Insurance">
                        <div class="project-item match-item">
                            <div class="project-item-img">
                                <img class="img-responsive" src="img/projects/p2.jpg" alt="project-2.jpg" />
                            </div>
                            <div class="project-item-title">
                                <a href="#"> Solar Plant: Solar Plant farm at Cape Town, South Africa $43 million USD</a>
                            </div>
                           
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6 col-xs-12 isotope-item Financial">
                        <div class="project-item match-item">
                            <div class="project-item-img">
                                <img class="img-responsive" src="img/projects/p3.jpg" alt="project-3.jpg" />
                            </div>
                            <div class="project-item-title">
                                <a href="#"> Gas Pipeline : Transcontinental Gas Pipeline laying, Kiev, Ukraine $105 million USD</a>
                            </div>
                           
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6 col-xs-12 isotope-item Taxes">
                        <div class="project-item match-item">
                            <div class="project-item-img">
                                <img class="img-responsive" src="img/projects/p4.jpg" alt="project-4.jpg" />
                            </div>
                            <div class="project-item-title">
                                <a href="#">Hydro Pump Storage Power Plant in Tunisia $105 million USD</a>
                            </div>
                           
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6 col-xs-12 isotope-item Insurance">
                        <div class="project-item match-item">
                            <div class="project-item-img">
                                <img class="img-responsive" src="img/projects/p5.jpg" alt="project-5.jpg" />
                            </div>
                            <div class="project-item-title">
                                <a href="#"> Mexico 4 facilities-Purchase of Mexican grown tomatoes, rice, vegetables, fruits, sugar, corn, beans, flour: $500K to $8 million USD</a>
                            </div>
                           
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6 col-xs-12 isotope-item Financial">
                        <div class="project-item match-item">
                            <div class="project-item-img">
                                <img class="img-responsive" src="img/projects/p6.jpg" alt="project-6.jpg" />
                            </div>
                            <div class="project-item-title">
                                <a href="#"> USA 4 facilities-Importation of US grown corn, rice, beans, almonds, pistachios, sorghum: $2 million to $27 million USD</a>
                            </div>
                            
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6 col-xs-12 isotope-item Investments">
                        <div class="project-item match-item">
                            <div class="project-item-img">
                                <img class="img-responsive" src="img/projects/p7.jpg" alt="project-7.jpg" />
                            </div>
                            <div class="project-item-title">
                                <a href="#"> Vietnam 2 facilities-Importation of rice from Vietnamese and Hindi brokers: $750K to $6 million USD.</a>
                            </div>
                            
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6 col-xs-12 isotope-item Financial">
                        <div class="project-item match-item">
                            <div class="project-item-img">
                                <img class="img-responsive" src="img/projects/p8.jpg" alt="project-8.jpg" />
                            </div>
                            <div class="project-item-title">
                                <a href="project-detail.html"> Gasoline 3 facilities-Direct purchase of gasoline from Pemex to service gas stations: $5 million to $6 million USD</a>
                            </div>
                            
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6 col-xs-12 isotope-item Insurance">
                        <div class="project-item match-item">
                            <div class="project-item-img">
                                <img class="img-responsive" src="img/projects/p9.jpg" alt="project-9.jpg" />
                            </div>
                            <div class="project-item-title">
                                <a href="#"> Diesel 1 facility-Purchase of diesel tank refueling from a Mexican Diesel broker: $400K USD</a>
                            </div>
                            
                        </div>
                    </div>


                    <div class="col-md-4 col-sm-6 col-xs-12 isotope-item Insurance">
                        <div class="project-item match-item">
                            <div class="project-item-img">
                                <img class="img-responsive" src="img/projects/p10.jpeg" alt="project-9.jpg" />
                            </div>
                            <div class="project-item-title">
                                <a href="#">  Marine diesel 1 facility-Purchase of Mexican marine diesel for a vessel fleet: $10 million USD</a>
                            </div>
                            
                        </div>
                    </div>


                    <div class="col-md-4 col-sm-6 col-xs-12 isotope-item Insurance">
                        <div class="project-item match-item">
                            <div class="project-item-img">
                                <img class="img-responsive" src="img/projects/p11.jpg" alt="project-9.jpg" />
                            </div>
                            <div class="project-item-title">
                                <a href="#">  Polyethylene 6 facilities-Purchase of polyethylene from a Mexican dealer of Pemex by-product: $200K to $6 million USD</a>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- END PROJECT LIST-->
<?php endif; ?>





<?php if($page_layout == 'Video Gallery Page Layout'): ?>
<!-- SECTION ABOUT, STYLE 2-->
        <section class="about about-layout-1">
            <div class="container">
                <div class="row">
                    <div class="col-md-6 col-sm-12 col-md-push-6">
                        <div class="image">
                            <img src="img/about/blog-5.jpg" alt="Our Team" />
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12 col-md-pull-6">
                        <div class="main-post">
                            <h3 class="heading">
                           Investor Relations
                            </h3>
                            <p class="content">
                                Worldbase Loan Services is committed to enhancing long-term value for investors and shareholders through prudent and effective allocation of resources. We are also transparent in our sharing of information with the financial community, including analysts, fund managers and other investors.
                                <br><br>

                                Worldbase Loan Services is committed to promoting the profession of investor relations to the international standards. Through sharing of ideas and views, and professional development programs, we expect to raise the awareness and enhance knowledge about the IR function in company-to-investor communications. I hope that Worldbase Loan Services will serve as an ideal platform for practitioners to keep in pace with the latest trends and the best IR practices, for networking opportunities and sharing of IR resources for all members. I am confident that the formation of Worldbase Loan Services will offer IROs access to valuable information.

                            </p>
                            


                                
                        </div>

                    </div>



                                <?php
// After form submit checking everything for email sending
if(isset($_POST['form_contact']))
{
	$error_message = '';
	$success_message = '';
	$statement = $pdo->prepare("SELECT * FROM tbl_settings WHERE id=1");
	$statement->execute();
	$result = $statement->fetchAll(PDO::FETCH_ASSOC);							
	foreach ($result as $row) 
	{
		$receive_email = $row['receive_email'];
		$receive_email_subject = $row['receive_email_subject'];
		$receive_email_thank_you_message = $row['receive_email_thank_you_message'];
	}

    $valid = 1;

    if(empty($_POST['visitor_name']))
    {
        $valid = 0;
        $error_message .= 'Please enter your name.\n';
    }

    if(empty($_POST['visitor_phone']))
    {
        $valid = 0;
        $error_message .= 'Please enter your phone number.\n';
    }

    if(empty($_POST['service']))
    {
        $valid = 0;
        $error_message .= 'Please Select Service.\n';
    }


    if(empty($_POST['visitor_email']))
    {
        $valid = 0;
        $error_message .= 'Please enter your email address.\n';
    }
    else
    {
    	// Email validation check
        if(!filter_var($_POST['visitor_email'], FILTER_VALIDATE_EMAIL))
        {
            $valid = 0;
            $error_message .= 'Please enter a valid email address.\n';
        }
    }

    

    if(empty($_POST['date']))
    {
        $valid = 0;
        $error_message .= 'Please enter date.\n';
    }

    if(empty($_POST['status']))
    {
        $valid = 0;
        $error_message .= 'Please enter Gender Status.\n';
    }

    if(empty($_POST['location']))
    {
        $valid = 0;
        $error_message .= 'Please specify where you heard about us.\n';
    }

    if(empty($_POST['residential']))
    {
        $valid = 0;
        $error_message .= 'Please specify your address.\n';
    }


    if(empty($_POST['city']))
    {
        $valid = 0;
        $error_message .= 'Please specify your city.\n';
    }

    if(empty($_POST['zip']))
    {
        $valid = 0;
        $error_message .= 'Please specify your zip code.\n';
    }





    if($valid == 1)
    {
		
		$visitor_name = strip_tags($_POST['visitor_name']);
		$visitor_email = strip_tags($_POST['visitor_email']);
		$visitor_phone = strip_tags($_POST['visitor_phone']);
        $date = strip_tags($_POST['date']);
        $status = strip_tags($_POST['status']);
        $location = strip_tags($_POST['location']);
        $gender = strip_tags($_POST['gender']);
        $residential = strip_tags($_POST['residential']);
        $city = strip_tags($_POST['city']);
        $zip = strip_tags($_POST['zip']);
		

        // sending email
        $to_admin = $receive_email;
        $subject = $receive_email_subject;
		$message = '
<html><body>
<table>
<tr>
<td>Name</td>
<td>'.$visitor_name.'</td>
</tr>
<tr>
<td>Email</td>
<td>'.$visitor_email.'</td>
</tr>
<tr>
<td>Phone</td>
<td>'.$visitor_phone.'</td>
</tr>
<tr>


<tr>
<td>Date of Birth</td>
<td>'.$date.'</td>
</tr>

<tr>
<td>Employment Status</td>
<td>'.$status.'</td>
</tr>

<tr>
<td>Where did you hear about us</td>
<td>'.$location.'</td>
</tr>

<tr>
<td>Gender</td>
<td>'.$gender.'</td>
</tr>

<tr>
<td>Residential Address</td>
<td>'.$residential.'</td>
</tr>

<tr>
<td>City</td>
<td>'.$city.'</td>
</tr>

<tr>
<td>Zip Code</td>
<td>'.$zip.'</td>
</tr>




</table>
</body></html>
';
		$headers = 'From: ' . $visitor_email . "\r\n" .
				   'Reply-To: ' . $visitor_email . "\r\n" .
				   'X-Mailer: PHP/' . phpversion() . "\r\n" . 
				   "MIME-Version: 1.0\r\n" . 
				   "Content-Type: text/html; charset=ISO-8859-1\r\n";

		// Sending email to admin				   
        mail($to_admin, $subject, $message, $headers); 
		
        $success_message = $receive_email_thank_you_message;

    }
}
?>
				
				<?php
				if($error_message != '') {
					echo "<script>alert('".$error_message."')</script>";
				}
				if($success_message != '') {
					echo "<script>alert('".$success_message."')</script>";
				}
				?>

                   <!-- GET A QUOTE, STYLE 1-->
                    <section class="quote-form quote-form-style-1">
                        <div class="heading">
                            <h3>Investors Application.</h3>
                        </div>

                        <form action="#" method="post">
                        <div class="form-group">
                            <div class="form-item">
                                <div class="label">
                                    <span>Full Name</span>
                                </div>
                                <div class="form-input">
                                    <input class="au-form-control au-form-radius" name="visitor_name" type="text" placeholder="Ex. John Posso" />
                                </div>
                            </div>
                            <div class="form-item">
                                <div class="label">
                                    <span>Mobile Number</span>
                                </div>
                                <div class="form-input">
                                    <input class="au-form-control au-form-radius" name="visitor_phone" type="text" placeholder="Ex. +1 8564145634" />
                                </div>

                            </div>
                            <div class="form-item">
                                <div class="label">
                                    <span>Email Address</span>
                                </div>
                                <div class="form-input">
                                    <input class="au-form-control au-form-radius" name="visitor_email" type="email" placeholder="Ex. johnposo@gmail.com" />
                                </div>

                            </div>

                            <div class="form-item">
                                <div class="label">
                                    <span>Date of Birth</span>
                                </div>
                                <div class="form-input">
                                    <input class="au-form-control au-form-radius" name="date" type="date" placeholder="mm-dd-yyyy" />
                                </div>
                            </div>

                            
                             

                            <div class="form-item">
                                <div class="form-item-group-item">
                                    <div class="label">
                                        <span>Emplyment Status</span>
                                    </div>
                                    <div class="form-input">
                                        <div class="fancy-select-wrapper form-input">
                                            <select class="basic" name="status">
                                                <option value="">Select Status</option>
                                                <option value="Self Employed">Self Employed</option>
                                                <option value="Salary Earner">Salary Earner</option>
                                                <option value="Business">Business</option>
                                                
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="form-item">
                                <div class="form-item-group-item">
                                    <div class="label">
                                        <span>Where did you hear about us</span>
                                    </div>
                                    <div class="form-input">
                                        <div class="fancy-select-wrapper form-input">
                                            <select class="basic" name="location">
                                                <option value="">TV</option>
                                                <option value="Outdoor">Outdoor</option>
                                                <option value="Boards">Boards</option>
                                                <option value="Social Media">Social Media</option>
                                                <option value="Blogs">Blogs</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            
                            <div class="form-item">
                                <div class="form-item-group-item">
                                    <div class="label">
                                        <span>Gender</span>
                                    </div>
                                    <div class="form-input">
                                        <div class="fancy-select-wrapper form-input">
                                            <select class="basic" name="gender">
                                                <option value="">Select Gender</option>
                                                <option value="Male">Male</option>
                                                <option value="Female">Female</option>
                                                
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                        <div class="heading">
                            <h3>Provide your current address:</h3>
                        </div>
                        <div class="form-group">
                            <div class="form-item">
                                <div class="label">
                                    <span>Residential Address</span>
                                </div>
                                <div class="form-input">
                                    <input class="au-form-control au-form-radius" name="residential" type="text" />
                                </div>
                            </div>
                           
                            <div class="form-item">
                                <div class="label">
                                    <span>City</span>
                                </div>
                                <div class="form-input">
                                    <input class="au-form-control au-form-radius" name="city" type="text" placeholder="Ohio" />
                                </div>
                            </div>
                            <div class="form-item">
                        
                                <div class="form-item-group-item">
                                    <div class="label">
                                        <span>ZIP Code</span>
                                    </div>
                                    <div class="form-input">
                                        <input class="au-form-control au-form-radius" name="zip" type="text" placeholder="113699" />
                                    </div>
                                </div>

                            </div>
                            


                        </div>
                        
                        <div class="form-button">
                            
                            <button class="au-btn au-btn-orange au-btn-md" name="form_contact" type="submit">Apply</button>
                        </div>
                    </form>
                    </section>
                    <!-- END GET A QUOTE, STYLE 1-->

















                </div>
            </div>
        </section>
        <!-- END SECTION ABOUT, STYLE 2-->
<?php endif; ?>



<?php if($page_layout == 'Blog Page Layout'): ?>
<section class="blog">
	<div class="container">
		<div class="row">
			<div class="col-md-9">
				
				<!-- Blog Classic Start -->
				<div class="blog-grid">
					<div class="row">
						<div class="col-md-12">
							

							<?php
							$statement = $pdo->prepare("SELECT * FROM tbl_news ORDER BY news_id DESC");
							$statement->execute();
							$total = $statement->rowCount();
							?>

							<?php if(!$total): ?>
							<p style="color:red;">Sorry! No News is found.</p>
							<?php else: ?>




<?php
/* ===================== Pagination Code Starts ================== */
		$adjacents = 10;	
		
		$statement = $pdo->prepare("SELECT * FROM tbl_news ORDER BY news_id DESC");
		$statement->execute();
		$total_pages = $statement->rowCount();
		
		$targetpage = $_SERVER['PHP_SELF'];
		$limit = 5;                                 
		$page = @$_GET['page'];
		if($page) 
			$start = ($page - 1) * $limit;          
		else
			$start = 0;	
		

		$statement = $pdo->prepare("SELECT
								   t1.news_title,
		                           t1.news_slug,
		                           t1.news_content,
		                           t1.news_date,
		                           t1.photo,
		                           t1.category_id,

		                           t2.category_id,
		                           t2.category_name,
		                           t2.category_slug
		                           FROM tbl_news t1
		                           JOIN tbl_category t2
		                           ON t1.category_id = t2.category_id 		                           
		                           ORDER BY t1.news_id 
		                           LIMIT $start, $limit");
		$statement->execute();
		$result = $statement->fetchAll(PDO::FETCH_ASSOC);
		
		
		$s1 = $_REQUEST['slug'];
				
		if ($page == 0) $page = 1;                  
		$prev = $page - 1;                          
		$next = $page + 1;                          
		$lastpage = ceil($total_pages/$limit);      
		$lpm1 = $lastpage - 1;   
		$pagination = "";
		if($lastpage > 1)
		{   
			$pagination .= "<div class=\"pagination\">";
			if ($page > 1) 
				$pagination.= "<a href=\"$targetpage?slug=$s1&page=$prev\">&#171; previous</a>";
			else
				$pagination.= "<span class=\"disabled\">&#171; previous</span>";    
			if ($lastpage < 7 + ($adjacents * 2))   //not enough pages to bother breaking it up
			{   
				for ($counter = 1; $counter <= $lastpage; $counter++)
				{
					if ($counter == $page)
						$pagination.= "<span class=\"current\">$counter</span>";
					else
						$pagination.= "<a href=\"$targetpage?slug=$s1&page=$counter\">$counter</a>";                 
				}
			}
			elseif($lastpage > 5 + ($adjacents * 2))    //enough pages to hide some
			{
				if($page < 1 + ($adjacents * 2))        
				{
					for ($counter = 1; $counter < 4 + ($adjacents * 2); $counter++)
					{
						if ($counter == $page)
							$pagination.= "<span class=\"current\">$counter</span>";
						else
							$pagination.= "<a href=\"$targetpage?slug=$s1&page=$counter\">$counter</a>";                 
					}
					$pagination.= "...";
					$pagination.= "<a href=\"$targetpage?slug=$s1&page=$lpm1\">$lpm1</a>";
					$pagination.= "<a href=\"$targetpage?slug=$s1&page=$lastpage\">$lastpage</a>";       
				}
				elseif($lastpage - ($adjacents * 2) > $page && $page > ($adjacents * 2))
				{
					$pagination.= "<a href=\"$targetpage?slug=$s1&page=1\">1</a>";
					$pagination.= "<a href=\"$targetpage?slug=$s1&page=2\">2</a>";
					$pagination.= "...";
					for ($counter = $page - $adjacents; $counter <= $page + $adjacents; $counter++)
					{
						if ($counter == $page)
							$pagination.= "<span class=\"current\">$counter</span>";
						else
							$pagination.= "<a href=\"$targetpage?slug=$s1&page=$counter\">$counter</a>";                 
					}
					$pagination.= "...";
					$pagination.= "<a href=\"$targetpage?slug=$s1&page=$lpm1\">$lpm1</a>";
					$pagination.= "<a href=\"$targetpage?slug=$s1&page=$lastpage\">$lastpage</a>";       
				}
				else
				{
					$pagination.= "<a href=\"$targetpage?slug=$s1&page=1\">1</a>";
					$pagination.= "<a href=\"$targetpage?slug=$s1&page=2\">2</a>";
					$pagination.= "...";
					for ($counter = $lastpage - (2 + ($adjacents * 2)); $counter <= $lastpage; $counter++)
					{
						if ($counter == $page)
							$pagination.= "<span class=\"current\">$counter</span>";
						else
							$pagination.= "<a href=\"$targetpage?slug=$s1&page=$counter\">$counter</a>";                 
					}
				}
			}
			if ($page < $counter - 1) 
				$pagination.= "<a href=\"$targetpage?slug=$s1&page=$next\">next &#187;</a>";
			else
				$pagination.= "<span class=\"disabled\">next &#187;</span>";
			$pagination.= "</div>\n";       
		}
		/* ===================== Pagination Code Ends ================== */
		?>

							<?php
							foreach ($result as $row) {
								?>
								<div class="post-item">
									<div class="image-holder">
										<img class="img-responsive" src="<?php echo BASE_URL; ?>assets/uploads/<?php echo $row['photo']; ?>" alt="<?php echo $row['news_title']; ?>">
									</div>
									<div class="text">
										<div class="inner">
											<h3><a href="<?php echo BASE_URL.URL_NEWS.$row['news_slug']; ?>"><?php echo $row['news_title']; ?></a></h3>
											<ul class="status">
												<li><i class="fa fa-tag"></i>Category: <a href="<?php echo BASE_URL.URL_CATEGORY.$row['category_slug']; ?>"><?php echo $row['category_name']; ?></a></li>
												<li><i class="fa fa-calendar"></i>Posted on: <?php echo $row['news_date']; ?></li>
											</ul>
											<p>
												<?php echo substr($row['news_content'],0,200).' ...'; ?>
											</p>
											<p class="button">
												<a href="<?php echo BASE_URL.URL_NEWS.$row['news_slug']; ?>">Read More</a>
											</p>
										</div>
									</div>
								</div>
								<?php
							}
							?>							
							<?php endif; ?>

						</div>

						<div class="col-md-12">
							<?php if($total): ?>
							<?php echo $pagination; ?>
							<?php endif; ?>
						</div>

					</div>
				</div>
				<!-- Blog Classic End -->

			</div>
			<div class="col-md-3">
				
				<?php require_once('sidebar.php'); ?>
			
			</div>

			


		</div>
	</div>
</section>
<?php endif; ?>



<?php if($page_layout == 'Team Member Page Layout'): ?>
<section class="team-member-v3">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				
				<!-- Team Member Container Start -->
				<div class="team-member-inner">
					
					<?php
					$statement = $pdo->prepare("SELECT
												
												t1.id,
												t1.name,
												t1.slug,
												t1.designation_id,
												t1.photo,
												t1.degree,
												t1.detail,
												t1.facebook,
												t1.twitter,
												t1.linkedin,
												t1.youtube,
												t1.google_plus,
												t1.instagram,
												t1.flickr,
												t1.address,
												t1.practice_location,
												t1.phone, 
												t1.email,
												t1.website,
												t1.status,

												t2.designation_id,
												t2.designation_name
						
					                            FROM tbl_team_member t1
					                            JOIN tbl_designation t2
					                            ON t1.designation_id = t2.designation_id
					                            WHERE t1.status=?
					                            ");
					$statement->execute(array('Active'));
					$result = $statement->fetchAll(PDO::FETCH_ASSOC);							
					foreach ($result as $row) {
						?>
						<div class="col-md-3 item">
							<div class="inner">
								<div class="thumb">
									<div class="photo" style="background-image:url(<?php echo BASE_URL; ?>assets/uploads/<?php echo $row['photo']; ?>)"></div>
									<div class="overlay"></div>
									<div class="social-icons">
										<ul>
											<?php if($row['facebook']!=''): ?>
												<li><a href="<?php echo $row['facebook']; ?>" target="_blank"><i class="fa fa-facebook"></i></a></li>
											<?php endif; ?>

											<?php if($row['twitter']!=''): ?>
												<li><a href="<?php echo $row['twitter']; ?>" target="_blank"><i class="fa fa-twitter"></i></a></li>
											<?php endif; ?>

											<?php if($row['linkedin']!=''): ?>
												<li><a href="<?php echo $row['linkedin']; ?>" target="_blank"><i class="fa fa-linkedin"></i></a></li>
											<?php endif; ?>

											<?php if($row['youtube']!=''): ?>
												<li><a href="<?php echo $row['youtube']; ?>" target="_blank"><i class="fa fa-youtube"></i></a></li>
											<?php endif; ?>

											<?php if($row['google_plus']!=''): ?>
												<li><a href="<?php echo $row['google_plus']; ?>" target="_blank"><i class="fa fa-google-plus"></i></a></li>
											<?php endif; ?>

											<?php if($row['instagram']!=''): ?>
												<li><a href="<?php echo $row['instagram']; ?>" target="_blank"><i class="fa fa-instagram"></i></a></li>
											<?php endif; ?>

											<?php if($row['flickr']!=''): ?>
												<li><a href="<?php echo $row['flickr']; ?>" target="_blank"><i class="fa fa-flickr"></i></a></li>
											<?php endif; ?>
										</ul>
									</div>
								</div>
								<div class="text">
									<h3><a href="<?php echo BASE_URL.URL_TEAM.$row['slug']; ?>"><?php echo $row['name']; ?></a></h3>
									<h4><?php echo $row['designation_name']; ?></h4>
									<p class="button">
										<a href="<?php echo BASE_URL.URL_TEAM.$row['slug']; ?>">See Full Profile</a>
									</p>
								</div>
							</div>
						</div>
						<?php
					}
					?>
					
				</div>
				<!-- Team Member Container End -->

			</div>
		</div>
	</div>
</section>
<?php endif; ?>
</div>


<?php require_once('footer.php'); ?>